/*
 * Decompiled with CFR 0.152.
 */
package score_calculators;

import data_structures.Gap_function;
import data_structures.MSA;
import data_structures.Residue_classification;
import data_structures.Residue_combinations;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import java.util.ArrayList;
import score_calculators.APro_calculator;
import score_calculators.PPro_calculator;
import score_calculators.TPro_calculator;

public class Score_calculator {
    public final SC_Structure structure_A;
    public final SC_Structure structure_B;
    private final MSA msa;
    private double[][] w_intraA;
    private double[][] w_intraB;

    public Score_calculator(MSA _msa, Gap_function g, SC_Structure strA, SC_Structure strB) {
        this.msa = _msa;
        this.structure_A = strA;
        this.structure_B = strB;
        this.Calculate_w_intra(g);
        APro_calculator.calculate_APro(strA, this.w_intraA, g.g_func1);
        APro_calculator.calculate_APro(strB, this.w_intraB, g.g_func2);
        PPro_calculator.calculate_PPro(strA, strB, this.w_intraA, g, true);
        PPro_calculator.calculate_PPro(strB, strA, this.w_intraB, g, false);
        TPro_calculator.calculate_TPro(strA, strB, this.w_intraA, g, true);
        TPro_calculator.calculate_TPro(strB, strA, this.w_intraB, g, false);
    }

    private void Calculate_w_intra(Gap_function G_func) {
        Residue_classification classit;
        Residue_classification classi;
        int it;
        ArrayList<Residue_type[]> sairs;
        this.w_intraA = new double[this.msa.sAlen][this.msa.sAlen];
        double[][] w_intraA_tmp = new double[this.msa.sAlen][this.msa.sAlen];
        this.w_intraB = new double[this.msa.sBlen][this.msa.sBlen];
        double[][] w_intraB_tmp = new double[this.msa.sBlen][this.msa.sBlen];
        for (Integer i : G_func.g_func1.keySet()) {
            sairs = G_func.g_func1.get(i);
            for (Residue_type[] array : sairs) {
                it = 0;
                while (it < this.msa.sAlen) {
                    if (array[it] != Residue_type.gap && it != i) {
                        classi = array[i.intValue()].classification;
                        classit = array[it].classification;
                        double[] dArray = this.w_intraA[i];
                        int n = it;
                        dArray[n] = dArray[n] + Residue_combinations.intra_weight_lookup[classi.ordinal()][classit.ordinal()];
                        double[] dArray2 = w_intraA_tmp[i];
                        int n2 = it;
                        dArray2[n2] = dArray2[n2] + 1.0;
                    }
                    ++it;
                }
            }
        }
        int i = 0;
        while (i < this.msa.sAlen) {
            int it2 = 0;
            while (it2 < this.msa.sAlen) {
                if (w_intraA_tmp[i][it2] != 0.0) {
                    this.w_intraA[i][it2] = this.w_intraA[i][it2] / w_intraA_tmp[i][it2];
                }
                ++it2;
            }
            ++i;
        }
        for (Integer i2 : G_func.g_func2.keySet()) {
            sairs = G_func.g_func2.get(i2);
            for (Residue_type[] array : sairs) {
                it = 0;
                while (it < this.msa.sBlen) {
                    if (array[it] != Residue_type.gap && it != i2) {
                        classi = array[i2.intValue()].classification;
                        classit = array[it].classification;
                        double[] dArray = this.w_intraB[i2];
                        int n = it;
                        dArray[n] = dArray[n] + Residue_combinations.intra_weight_lookup[classi.ordinal()][classit.ordinal()];
                        double[] dArray3 = w_intraB_tmp[i2];
                        int n3 = it;
                        dArray3[n3] = dArray3[n3] + 1.0;
                    }
                    ++it;
                }
            }
        }
        int i3 = 0;
        while (i3 < this.msa.sBlen) {
            int it3 = 0;
            while (it3 < this.msa.sBlen) {
                if (w_intraB_tmp[i3][it3] != 0.0) {
                    this.w_intraB[i3][it3] = this.w_intraB[i3][it3] / w_intraB_tmp[i3][it3];
                }
                ++it3;
            }
            ++i3;
        }
    }
}

