/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import utils.FileSystemTools;

public class SmithWaterman {
    public static void main(String[] args) {
        String seq1 = "HHHDADHHHHHYYYYHHHH";
        String seq2 = "HHHHHADADADYYYYHHHH";
        SmithWaterman.computeIdentity(seq1, seq2);
    }

    public static double scoreSW(String seq1, String seq2) {
        FileSystemTools.writeFile("input1", String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences", ">\n" + seq1);
        FileSystemTools.writeFile("input2", String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences", ">\n" + seq2);
        SmithWaterman.runSW();
        ArrayList<String> output = FileSystemTools.readFile("out", String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences");
        int i = 0;
        while (!output.get(i).equals("score")) {
            ++i;
        }
        String score = output.get(i + 1);
        score = score.substring(1, score.indexOf(","));
        return Double.parseDouble(score);
    }

    public static double computeIdentity(String seq1, String seq2) {
        int s2l;
        FileSystemTools.writeFile("input1", String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences", ">\n" + seq1);
        FileSystemTools.writeFile("input2", String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences", ">\n" + seq2);
        SmithWaterman.runSW();
        ArrayList<String> output = FileSystemTools.readFile("out", String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences");
        String out1 = "";
        String out2 = "";
        int i = 0;
        while (i < output.size()) {
            if (output.get(i).equals("sequence1")) {
                out1 = output.get(++i);
            }
            if (output.get(i).equals("sequence2")) {
                out2 = output.get(++i);
            }
            ++i;
        }
        int equal = 0;
        int i2 = 0;
        while (i2 < out1.length()) {
            if (out1.charAt(i2) == out2.charAt(i2) && out2.charAt(i2) != '-') {
                ++equal;
            }
            ++i2;
        }
        int s1l = seq1.length();
        int shorter_len = s1l > (s2l = seq2.length()) ? s2l : s1l;
        return (double)equal / (double)shorter_len;
    }

    public static void CleanUp() {
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec("rm " + System.getProperty("user.dir") + "/auxiliarysoftware/sequences/out ");
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    private static void runSW() {
        try {
            String s;
            Process p_psa = Runtime.getRuntime().exec(String.valueOf(System.getProperty("user.dir")) + "/auxiliarysoftware/sequences/./Konrad " + System.getProperty("user.dir") + "/auxiliarysoftware/sequences/input1 " + System.getProperty("user.dir") + "/auxiliarysoftware/sequences/input2 " + System.getProperty("user.dir") + "/auxiliarysoftware/sequences/out " + System.getProperty("user.dir") + "/auxiliarysoftware/sequences/BLOSUM62.txt");
            BufferedReader stdInput_psa = new BufferedReader(new InputStreamReader(p_psa.getInputStream()));
            BufferedReader stdError_psa = new BufferedReader(new InputStreamReader(p_psa.getErrorStream()));
            while ((s = stdError_psa.readLine()) != null) {
                System.err.println(s);
            }
            while ((s = stdInput_psa.readLine()) != null) {
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

