/*
 * Decompiled with CFR 0.152.
 */
package utils;

import for_terry.DBStats;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import utils.FileSystemTools;

public class WebTools {
    public static void main(String[] args) throws IOException {
        HashMap<String, String> res = WebTools.downloadCDRRealChain("1AHW", "AB");
        for (String key : res.keySet()) {
            System.out.println(String.valueOf(key) + " : " + res.get(key));
        }
    }

    public static HashMap<String, String> downloadCDR(String pdb_code, String chai) {
        HashMap<String, String> res = WebTools.getOneSet(pdb_code, chai);
        HashMap<String, String> chains = null;
        if (res != null) {
            chains = WebTools.getCDRSequences(pdb_code, res.get("h"), res.get("l"), 0);
        }
        return chains;
    }

    public static HashMap<String, String> downloadCDRRealChain(String pdb_code, String chai) {
        HashMap<String, String> res = WebTools.getOneSetRealChain(pdb_code, chai);
        HashMap<String, String> chains = null;
        if (res != null) {
            chains = WebTools.getCDRSequences(pdb_code, res.get("h"), res.get("l"), 0);
        }
        return chains;
    }

    public static HashMap<String, String> getOneSetRealChain(String pdb_code, String chains_info) {
        String h_id = "chainId=" + pdb_code.toLowerCase() + "_" + chains_info.charAt(0);
        String l_id = "chainId=" + pdb_code.toLowerCase() + "_" + chains_info.charAt(1);
        System.out.println(h_id);
        HashMap<String, String> result = new HashMap<String, String>();
        int repeats = 1;
        while (repeats > 0) {
            System.out.println("Remaining: " + repeats);
            String pdb = pdb_code.toLowerCase();
            String url = "http://www.imgt.org/3Dstructure-DB/cgi/details.cgi?pdbcode=" + pdb;
            String start = "Sequence in FASTA format</em></a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"";
            String end = "\"><em>Sequence in IMGT format</em>";
            ArrayList<Object> links = new ArrayList();
            String link_h = null;
            if (chains_info.charAt(0) != '_') {
                String after_h = "<td colspan='2' class='data_h'><b><a name=";
                if (repeats < 100 && repeats % 2 == 0) {
                    after_h = "<td colspan='2' class='data_l'><b><a name=";
                }
                links = WebTools.readWebPage(start, end, url);
                for (String string : links) {
                    System.out.println("Got link \n" + string);
                    if (!string.contains(h_id)) continue;
                    link_h = string;
                    break;
                }
            }
            String link_l = null;
            if (chains_info.charAt(1) != '_') {
                String string = "<td colspan='2' class='data_l'><b><a name=";
                if (repeats < 100 && repeats % 2 == 0) {
                    String string2 = "<td colspan='2' class='data_h'><b><a name=";
                }
                links = WebTools.readWebPage(start, end, url);
                for (String string3 : links) {
                    if (!string3.contains(l_id)) continue;
                    link_l = string3;
                    break;
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(link_h != null && link_h.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_h : null);
            arrayList.add(link_l != null && link_l.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_l : null);
            if (link_l != null && link_l.length() != 0 || link_h != null && link_h.length() != 0) {
                result.put("l", link_l != null && link_l.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_l : null);
                result.put("h", link_h != null && link_h.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_h : null);
                System.out.println(link_h);
                return result;
            }
            --repeats;
        }
        return null;
    }

    public static HashMap<String, String> getOneSet(String pdb_code, String chains_info) {
        HashMap<String, DBStats.PDB_record> map = DBStats.getLHMapping();
        System.out.println("Got this: " + map.get(pdb_code));
        String h_id = "chainId=" + pdb_code.toLowerCase() + "_" + map.get((Object)pdb_code).H;
        String l_id = "chainId=" + pdb_code.toLowerCase() + "_" + map.get((Object)pdb_code).L;
        System.out.println(h_id);
        HashMap<String, String> result = new HashMap<String, String>();
        int repeats = 1;
        while (repeats > 0) {
            System.out.println("Remaining: " + repeats);
            String pdb = pdb_code.toLowerCase();
            String url = "http://www.imgt.org/3Dstructure-DB/cgi/details.cgi?pdbcode=" + pdb;
            String start = "Sequence in FASTA format<i></a>&nbsp;&nbsp;&nbsp;&nbsp;<a target='_blank' href='";
            String end = "'><i>Sequence in IMGT format";
            ArrayList<Object> links = new ArrayList();
            String link_h = null;
            if (chains_info.charAt(0) != '_') {
                String after_h = "<td colspan='2' class='data_h'><b><a name=";
                if (repeats < 100 && repeats % 2 == 0) {
                    after_h = "<td colspan='2' class='data_l'><b><a name=";
                }
                links = WebTools.readWebPage(start, end, url);
                for (String string : links) {
                    if (!string.contains(h_id)) continue;
                    link_h = string;
                    break;
                }
            }
            String link_l = null;
            if (chains_info.charAt(1) != '_') {
                String string = "<td colspan='2' class='data_l'><b><a name=";
                if (repeats < 100 && repeats % 2 == 0) {
                    String string2 = "<td colspan='2' class='data_h'><b><a name=";
                }
                links = WebTools.readWebPage(start, end, url);
                for (String string3 : links) {
                    if (!string3.contains(l_id)) continue;
                    link_l = string3;
                    break;
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(link_h != null && link_h.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_h : null);
            arrayList.add(link_l != null && link_l.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_l : null);
            if (link_l != null && link_l.length() != 0 || link_h != null && link_h.length() != 0) {
                result.put("l", link_l != null && link_l.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_l : null);
                result.put("h", link_h != null && link_h.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_h : null);
                System.out.println(link_h);
                return result;
            }
            --repeats;
        }
        return null;
    }

    public static HashMap<String, ArrayList<String>> getURLS(HashMap<String, String> pdbs) {
        HashMap<String, ArrayList<String>> mapping = new HashMap<String, ArrayList<String>>();
        ArrayList<String> mapping_negative = new ArrayList<String>();
        int map_size = pdbs.size();
        int i = 1;
        for (String pdb_code : pdbs.keySet()) {
            int repeats = 100;
            while (repeats > 0) {
                String pdb = pdb_code.toLowerCase();
                String url = "http://www.imgt.org/3Dstructure-DB/cgi/details.cgi?pdbcode=" + pdb;
                String start = "Sequence in FASTA format<i></a>&nbsp;&nbsp;&nbsp;&nbsp;<a target='_blank' href='";
                String end = "'><i>Sequence in IMGT format";
                String link_h = null;
                if (pdbs.get(pdb_code).charAt(0) != '_') {
                    String after_h = "<td colspan='2' class='data_h'><b><a name=";
                    if (repeats < 100 && repeats % 2 == 0) {
                        after_h = "<td colspan='2' class='data_l'><b><a name=";
                    }
                    link_h = WebTools.readWebPage(start, end, url, after_h);
                }
                String link_l = null;
                if (pdbs.get(pdb_code).charAt(1) != '_') {
                    String after_l = "<td colspan='2' class='data_l'><b><a name=";
                    if (repeats < 100 && repeats % 2 == 0) {
                        after_l = "<td colspan='2' class='data_h'><b><a name=";
                    }
                    link_l = WebTools.readWebPage(start, end, url, after_l);
                }
                ArrayList<String> chains = new ArrayList<String>();
                chains.add(link_h != null && link_h.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_h : null);
                chains.add(link_l != null && link_l.length() != 0 ? "http://www.imgt.org/3Dstructure-DB/cgi/" + link_l : null);
                if (link_l != null && link_l.length() != 0 || link_h != null && link_h.length() != 0) {
                    mapping.put(pdb, chains);
                    repeats = 0;
                    continue;
                }
                if (--repeats != 0) continue;
                mapping_negative.add(String.valueOf(pdb) + pdbs.get(pdb));
            }
            ++i;
        }
        for (String string : mapping_negative) {
        }
        return mapping;
    }

    public static HashMap<String, String> getCDRSequences(String pdb_code, String heavy, String light, int shift) {
        String temp_chains;
        String start;
        HashMap<String, String> cdr_mapping = new HashMap<String, String>();
        cdr_mapping.put("H1", null);
        cdr_mapping.put("H2", null);
        cdr_mapping.put("H3", null);
        cdr_mapping.put("L1", null);
        cdr_mapping.put("L2", null);
        cdr_mapping.put("L3", null);
        String end = "</span>";
        if (heavy != null) {
            start = "title=\"CDR1-IMGT\">";
            temp_chains = WebTools.extractLoops(heavy, start, end, shift);
            cdr_mapping.put("H1", temp_chains != null ? temp_chains : null);
            start = "title=\"CDR2-IMGT\">";
            temp_chains = WebTools.extractLoops(heavy, start, end, shift);
            cdr_mapping.put("H2", temp_chains != null ? temp_chains : null);
            start = "title=\"CDR3-IMGT\">";
            temp_chains = WebTools.extractLoops(heavy, start, end, shift);
            cdr_mapping.put("H3", temp_chains != null ? temp_chains : null);
        }
        if (light != null) {
            start = "title=\"CDR1-IMGT\">";
            temp_chains = WebTools.extractLoops(light, start, end, shift);
            cdr_mapping.put("L1", temp_chains != null ? temp_chains : null);
            start = "title=\"CDR2-IMGT\">";
            temp_chains = WebTools.extractLoops(light, start, end, shift);
            cdr_mapping.put("L2", temp_chains != null ? temp_chains : null);
            start = "title=\"CDR3-IMGT\">";
            temp_chains = WebTools.extractLoops(light, start, end, shift);
            cdr_mapping.put("L3", temp_chains != null ? temp_chains : null);
        }
        return cdr_mapping;
    }

    public static HashMap<String, Integer> getCDRPositions(String pdb_code, String heavy, String light) {
        Integer temp_chains;
        String start;
        HashMap<String, Integer> cdr_mapping = new HashMap<String, Integer>();
        String end = "</span>";
        if (heavy != null) {
            start = "title=\"CDR1-IMGT\">";
            temp_chains = WebTools.extractLoopPosition(heavy, start, end);
            cdr_mapping.put("CDRH1", temp_chains != -1 ? temp_chains : null);
            start = "title=\"CDR2-IMGT\">";
            temp_chains = WebTools.extractLoopPosition(heavy, start, end);
            cdr_mapping.put("CDRH2", temp_chains != -1 ? temp_chains : null);
            start = "title=\"CDR3-IMGT\">";
            temp_chains = WebTools.extractLoopPosition(heavy, start, end);
            cdr_mapping.put("CDRH3", temp_chains != -1 ? temp_chains : null);
        }
        if (light != null) {
            start = "title=\"CDR1-IMGT\">";
            temp_chains = WebTools.extractLoopPosition(light, start, end);
            cdr_mapping.put("CDRL1", temp_chains != -1 ? temp_chains : null);
            start = "title=\"CDR2-IMGT\">";
            temp_chains = WebTools.extractLoopPosition(light, start, end);
            cdr_mapping.put("CDRL2", temp_chains != -1 ? temp_chains : null);
            start = "title=\"CDR3-IMGT\">";
            temp_chains = WebTools.extractLoopPosition(light, start, end);
            cdr_mapping.put("CDRL3", temp_chains != -1 ? temp_chains : null);
        }
        return cdr_mapping;
    }

    public static String extractLoops(String url, String start, String end, int shift) {
        String annotated = "";
        String start_tmp = start.toUpperCase();
        String end_tmp = end.toUpperCase();
        ArrayList<String> chain = WebTools.readWebPagePattern(start, url);
        for (String s : chain) {
            s = s.toUpperCase();
            s = WebTools.tagBetween(s, start_tmp, end_tmp);
            s = WebTools.removeNumerals(s);
            s = s.replace(" ", "");
            annotated = String.valueOf(annotated) + s;
        }
        int first = annotated.indexOf(95);
        int second = annotated.substring(first + 1).indexOf(95) + first + 1;
        if (second - first == 1) {
            return null;
        }
        return WebTools.removeBetween(annotated, "_", "_", shift);
    }

    public static int extractLoopPosition(String url, String start, String end) {
        String annotated = "";
        String start_tmp = start.toUpperCase();
        String end_tmp = end.toUpperCase();
        ArrayList<String> chain = WebTools.readWebPagePattern(start, url);
        for (String s : chain) {
            s = s.toUpperCase();
            s = WebTools.tagBetween(s, start_tmp, end_tmp);
            s = WebTools.removeNumerals(s);
            s = s.replace(" ", "");
            annotated = String.valueOf(annotated) + s;
        }
        return annotated.indexOf(95);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<String> readWebPage(String start, String end, String urltext) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL url = new URL(urltext);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            block4: while (true) {
                String inputLine;
                if ((inputLine = in.readLine()) == null) {
                    in.close();
                    break;
                }
                while (true) {
                    if (!inputLine.contains(start)) continue block4;
                    int starting = inputLine.indexOf(start) + start.length();
                    inputLine = inputLine.substring(starting);
                    int ending = inputLine.indexOf(end);
                    result.add(inputLine.substring(0, ending));
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not locate pdb " + urltext);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result.size() == 0) {
            return null;
        }
        ArrayList<String> arrayList = result;
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWebPage(String start, String end, String urltext, String after) {
        String result = "";
        try {
            String inputLine;
            URL url = new URL(urltext);
            System.out.println(urltext);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            boolean search_mode = true;
            block4: while ((inputLine = in.readLine()) != null) {
                if (search_mode) {
                    if (!inputLine.contains(after)) continue;
                    search_mode = false;
                    continue;
                }
                while (true) {
                    if (!inputLine.contains(start)) {
                        if (result.length() == 0) continue block4;
                        break block4;
                    }
                    int starting = inputLine.indexOf(start) + start.length();
                    inputLine = inputLine.substring(starting);
                    int ending = inputLine.indexOf(end);
                    result = String.valueOf(result) + inputLine.substring(0, ending);
                }
            }
            in.close();
            return result;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not locate pdb " + urltext);
            return result;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ArrayList<String> readWebPage(String urltext) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String inputLine;
            URL url = new URL(urltext);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            boolean search_mode = true;
            while ((inputLine = in.readLine()) != null) {
                result.add(inputLine);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not locate pdb " + urltext);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ArrayList<String> newReadPage(String url_addr) {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            String urlString = url_addr;
            URL url = new URL(urlString);
            URLConnection uc = url.openConnection();
            uc.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
            uc.connect();
            uc.getInputStream();
            BufferedInputStream in_2 = new BufferedInputStream(uc.getInputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(in_2));
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<String> readWebPagePattern(String pattern, String urltext) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            String inputLine;
            URL url = new URL(urltext);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((inputLine = in.readLine()) != null) {
                if (!(inputLine = inputLine.toUpperCase()).contains(pattern.toUpperCase())) continue;
                output.add(inputLine);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not locate pdb " + urltext);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static void writeWebPage(String filename, String directory, String urltext) {
        try {
            String inputLine;
            URL url = new URL(urltext);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String data = "";
            while ((inputLine = in.readLine()) != null) {
                data = String.valueOf(data) + inputLine + "\n";
            }
            FileSystemTools.writeFile(filename, directory, data);
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not locate pdb");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String removeNumerals(String s) {
        String result = s;
        result = result.replace("0", "");
        result = result.replace("1", "");
        result = result.replace("2", "");
        result = result.replace("3", "");
        result = result.replace("4", "");
        result = result.replace("5", "");
        result = result.replace("6", "");
        result = result.replace("7", "");
        result = result.replace("8", "");
        result = result.replace("9", "");
        return result;
    }

    private static String getBetween(String inputLine, String start, String end, int shift) {
        String result = "";
        String prefix = "";
        String suffix = "";
        while (inputLine.contains(start)) {
            int starting = inputLine.indexOf(start) + start.length();
            prefix = String.valueOf(prefix) + inputLine.substring(starting - shift, starting);
            inputLine = inputLine.substring(starting);
            int ending = inputLine.indexOf(end);
            result = String.valueOf(result) + inputLine.substring(0, ending);
            suffix = inputLine.substring(ending + 1, ending + shift + 1);
            inputLine = inputLine.indexOf(end) != inputLine.length() - 1 ? inputLine.substring(ending + 1) : "";
        }
        return result;
    }

    private static String tagBetween(String input, String start, String end) {
        String inputLine = input;
        String result = "";
        while (inputLine.contains(start)) {
            int starting = inputLine.indexOf(start) + start.length();
            result = String.valueOf(result) + inputLine.substring(0, starting) + "_";
            inputLine = inputLine.substring(starting);
            int ending = inputLine.indexOf(end);
            result = String.valueOf(result) + inputLine.substring(0, ending) + "_";
            inputLine = inputLine.substring(ending);
        }
        return WebTools.removeContentBetween(String.valueOf(result) + inputLine, "<", ">");
    }

    private static String removeContentBetween(String inputLine, String start, String end) {
        if (inputLine.contains(start) && inputLine.substring(inputLine.indexOf(start) + 1).contains(end)) {
            boolean ending = false;
            String result = "";
            while (inputLine.contains(start) && inputLine.substring(inputLine.indexOf(start) + 1).contains(end)) {
                result = String.valueOf(result) + inputLine.substring(0, inputLine.indexOf(start));
                inputLine = inputLine.substring(inputLine.indexOf(end) + 1);
            }
            return String.valueOf(result) + inputLine;
        }
        return null;
    }

    private static String removeBetween(String inputLine, String start, String end, int shift) {
        if (inputLine.contains(start) && inputLine.substring(inputLine.indexOf(start) + 1).contains(end)) {
            int ending = 0;
            String result = "";
            String prefix = "";
            if (inputLine.substring(0, inputLine.indexOf(start)).length() > shift) {
                prefix = inputLine.substring(inputLine.indexOf(start) - shift, inputLine.indexOf(start));
            }
            while (inputLine.contains(start) && inputLine.substring(inputLine.indexOf(start) + 1).contains(end)) {
                inputLine = inputLine.substring(inputLine.indexOf(start) + 1);
                ending = inputLine.indexOf(end);
                result = String.valueOf(result) + inputLine.substring(0, ending);
                inputLine = inputLine.substring(ending + 1);
            }
            String suffix = "";
            if (inputLine.length() >= shift) {
                suffix = inputLine.substring(0, shift);
            }
            return String.valueOf(prefix) + result + suffix;
        }
        return null;
    }
}

