#!/usr/bin/env python

import distutils.log
from distutils.command import install_lib
from distutils.core import setup, Extension
import numpy as np
import os

# custom class to ensure executables are installed with the correct file permissions
class my_install_lib(install_lib.install_lib):
  def run(self):
    install_lib.install_lib.run(self)
    for fn in self.get_outputs():
      if os.path.basename(fn) in ["RAPDF", "dDFIRE", "calRWplus"]:
        mode = ((os.stat(fn).st_mode) | 0o555) & 0o7777
        distutils.log.info("changing mode of %s to %o", fn, mode)
        os.chmod(fn, mode)

numpy_include_dir = np.get_include()

setup(name = "sphinx",
      version = "1.0",
      description = "Sphinx: Hybrid Loop Prediction method",
      author = "Claire Marks",
      author_email = "marks@stats.ox.ac.uk",
      cmdclass={'install_lib':my_install_lib},

      packages = [
          "sphinx",
          "sphinx.fragments", 
          "sphinx.mechano",   
          "sphinx.ranking",   
          "sphinx.contacts",
          "sphinx.sidechains",
      ],
      
      package_dir = {
         "sphinx": "lib/python/sphinx",
         "sphinx.fragments": "lib/python/sphinx/fragments",
         "sphinx.mechano": "lib/python/sphinx/mechano",
         "sphinx.ranking": "lib/python/sphinx/ranking",
         "sphinx.contacts": "lib/python/sphinx/contacts",
         "sphinx.sidechains": "lib/python/sphinx/sidechains",
     },

     package_data = {
         "sphinx": ["dat/*.csv", "dat/esst.txt"],
         "sphinx.mechano": ["DATA/general/CCD_data/*", "DATA/general/dihedral_data/*", "DATA/h3/CCD_data/*", "DATA/h3/dihedral_data/*", "DATA/membrane/CCD_data/*", "DATA/membrane/idihedral_data/*"],
         "sphinx.ranking.ranking_execs": ["RAPDF", "dDFIRE/*", "RWplus/*"],
     },

     scripts = ['bin/Sphinx', "bin/SphinxWrap"],

     ext_modules = [ 
                        Extension("sphinx.mechano.MECHANO", 
                               sources = [ "lib/python/sphinx/mechano/MECHANO.c" ],
                               libraries = [ "m" ]),

                   ]
     
     )
